<!doctype html>
<html lang="pt-BR"><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<title>Detalhes da Consulta</title>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
</head><body class="hold-transition layout-top-nav">
<div class="wrapper">
<div class="content-wrapper p-3">
  <div class="card card-body">
    <h5><?= htmlspecialchars($a['consult'] ?? 'Consulta') ?> — <?= ((int)$a['is_online']===1?'Online':'Presencial') ?></h5>
    <p><b>Profissional:</b> <?= htmlspecialchars($a['doctor']) ?></p>
    <p><b>Data:</b> <?= htmlspecialchars(substr($a['start_time'],0,16)) ?> — <b>Término:</b> <?= htmlspecialchars(substr($a['end_time'],0,16)) ?></p>
    <?php if ((int)$a['is_online']===1): ?>
      <?php
        $today = date('Y-m-d');
        $apptDay = substr($a['start_time'],0,10);
        if ($today === $apptDay && $urls && !empty($urls['patient_url'])):
      ?>
        <a class="btn btn-success" href="<?= htmlspecialchars($urls['patient_url']) ?>" target="_blank">Entrar na sala</a>
        <p class="text-muted mt-2">A sala fica disponível apenas no dia da consulta.</p>
      <?php else: ?>
        <div class="alert alert-info">O link da sala ficará disponível no dia da consulta.</div>
      <?php endif; ?>
    <?php else: ?>
      <div class="alert alert-secondary">Consulta presencial — comparecer ao consultório no horário agendado.</div>
    <?php endif; ?>
  </div>
</div>
</div>
</body></html>
