<?php include __DIR__.'/../partials/_hdr.php'; ?>
<section class="content">
  <div class="row">
    <div class="col-md-5">
      <div class="card card-body">
        <h5>Criar / Editar Consulta</h5>
        <form action="/admin/consultations" method="post">
          <input type="hidden" name="_csrf" value="<?= htmlspecialchars(csrf_token()) ?>">
          <input type="hidden" name="id" id="form_id">
          <div class="form-group"><label>Nome</label><input name="name" id="form_name" class="form-control" required></div>
          <div class="form-group"><label>Descrição</label><textarea name="description" id="form_description" class="form-control" rows="3"></textarea></div>
          <div class="form-group"><label>Preço (R$)</label><input type="number" step="0.01" min="0" name="price" id="form_price" class="form-control" required></div>
          <div class="form-check mb-2"><input type="checkbox" class="form-check-input" name="is_active" id="form_active" checked><label class="form-check-label" for="form_active">Ativo</label></div>
          <div class="form-check mb-3"><input type="checkbox" class="form-check-input" name="is_online" id="form_online"><label class="form-check-label" for="form_online">Atendimento online (gera sala)</label></div>
          <button class="btn btn-primary">Salvar</button>
        </form>
      </div>
    </div>
    <div class="col-md-7">
      <div class="card card-body">
        <h5>Consultas cadastradas</h5>
        <table class="table table-sm table-striped"><thead><tr><th>Nome</th><th>Preço</th><th>Status</th><th></th></tr></thead><tbody>
        <?php foreach($rows as $r): ?>
          <tr>
            <td><b><?= htmlspecialchars($r['name']) ?></b><br><small class="text-muted"><?= nl2br(htmlspecialchars($r['description'] ?? '')) ?></small></td>
            <td>R$ <?= number_format((float)$r['price'],2,',','.') ?><br><small class="badge badge-<?= ((int)$r['is_online']? 'success':'secondary') ?>"><?= ((int)$r['is_online']? 'Online':'Presencial') ?></small></td>
            <td><?= ((int)$r['is_active'] ? 'Ativo' : 'Inativo') ?></td>
            <td class="text-right">
              <button class="btn btn-sm btn-outline-primary" onclick="fillForm(<?= (int)$r['id'] ?>,'<?= htmlspecialchars($r['name'],ENT_QUOTES) ?>','<?= htmlspecialchars($r['description'] ?? '',ENT_QUOTES) ?>','<?= (float)$r['price'] ?>',<?= (int)$r['is_active'] ?>,<?= (int)$r['is_online'] ?>)">Editar</button>
              <form action="/admin/consultations/delete" method="post" style="display:inline-block" onsubmit="return confirm('Confirmar exclusão?')">
                <input type="hidden" name="_csrf" value="<?= htmlspecialchars(csrf_token()) ?>">
                <input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
                <button class="btn btn-sm btn-outline-danger">Excluir</button>
              </form>
            </td>
          </tr>
        <?php endforeach; ?>
        </tbody></table>
      </div>
    </div>
  </div>
</section>
<script>
function fillForm(id,name,description,price,active,online){
  form_id.value=id; form_name.value=name; form_description.value=description; form_price.value=price; form_active.checked=!!active; form_online.checked=!!online;
  window.scrollTo({top:0, behavior:'smooth'});
}
</script>
<?php include __DIR__.'/../partials/_ftr.php'; ?>
