<?php
declare(strict_types=1);
namespace App\Telemed;
class JitsiProvider implements TeleProviderInterface {
    public function createMeeting(array $credentials, array $params): array {
        $base = $credentials['base'] ?? 'https://meet.jit.si';
        $room = 'ClinicaPsiquiatria-' . bin2hex(random_bytes(4));
        $url = rtrim($base,'/') . '/' . $room;
        return ['doctor_url'=>$url,'patient_url'=>$url,'provider_ref'=>'JITSI-'.uniqid()];
    }
}
