<?php
declare(strict_types=1);
namespace App\Controllers;
use App\Core\DB;

class AppointmentDetailApi {
    public static function get(): string {
        if (!is_authenticated()) { http_response_code(403); return json_encode(['error'=>'auth']); }
        header('Content-Type: application/json; charset=utf-8');
        $id = (int)($_GET['id'] ?? 0);
        $pdo = DB::pdo();
        $row = $pdo->prepare("SELECT a.id, a.start_time, a.end_time, p.name AS patient, ct.name AS consult, ct.is_online
                              FROM appointments a
                              JOIN patients p ON p.id=a.patient_id
                              LEFT JOIN consultation_types ct ON ct.id=a.consultation_type_id
                              WHERE a.id=?");
        $row->execute([$id]); $a = $row->fetch();
        if (!$a) return json_encode(['error'=>'notfound']);
        $urls = null;
        $file = __DIR__.'/../storage/tele_'.$a['id'].'.json';
        if ((int)$a['is_online'] === 1 && is_file($file)) { $urls = json_decode(file_get_contents($file), true); }
        $a['join_url'] = $urls['doctor_url'] ?? null;
        return json_encode($a);
    }
}
