<?php
declare(strict_types=1);
namespace App\Controllers\Admin;
use App\Core\DB;

class ScheduleAdminController {
    public static function workingHours(): string {
        if (!is_authenticated() || ($_SESSION['role']??'')!=='admin') return redirect('/');
        $pdo = DB::pdo();
        $medicos = $pdo->query("SELECT id, name FROM users WHERE role='medico' AND is_active=1 ORDER BY name")->fetchAll();
        return view('admin/working_hours', ['medicos'=>$medicos]);
    }
    public static function saveWorkingHours(): string {
        if (!is_authenticated() || ($_SESSION['role']??'')!=='admin') return redirect('/');
        if (!csrf_check($_POST['_csrf'] ?? '')) { http_response_code(400); return 'Invalid CSRF'; }
        $pdo = DB::pdo();
        $user = (int)$_POST['user_id'];
        $pdo->prepare('DELETE FROM working_hours WHERE user_id=?')->execute([$user]);
        for ($w=1; $w<=5; $w++) {
            $st = $_POST['start_'.$w] ?? ''; $et = $_POST['end_'.$w] ?? '';
            if ($st && $et) { $pdo->prepare('INSERT INTO working_hours (user_id, weekday, start_time, end_time) VALUES (?,?,?,?)')->execute([$user,$w,$st,$et]); }
        }
        return redirect('/admin/working-hours');
    }
    public static function holidays(): string {
        if (!is_authenticated() || ($_SESSION['role']??'')!=='admin') return redirect('/');
        $pdo = DB::pdo();
        $list = $pdo->query('SELECT * FROM holidays ORDER BY date DESC')->fetchAll();
        return view('admin/holidays', ['list'=>$list]);
    }
    public static function addHoliday(): string {
        if (!is_authenticated() || ($_SESSION['role']??'')!=='admin') return redirect('/');
        if (!csrf_check($_POST['_csrf'] ?? '')) { http_response_code(400); return 'Invalid CSRF'; }
        $pdo = DB::pdo();
        $pdo->prepare('INSERT INTO holidays (date, reason) VALUES (?,?) ON DUPLICATE KEY UPDATE reason=VALUES(reason)')->execute([$_POST['date'], $_POST['reason'] ?? null]);
        return redirect('/admin/holidays');
    }
    public static function delHoliday(): string {
        if (!is_authenticated() || ($_SESSION['role']??'')!=='admin') return redirect('/');
        if (!csrf_check($_POST['_csrf'] ?? '')) { http_response_code(400); return 'Invalid CSRF'; }
        $pdo = DB::pdo();
        $pdo->prepare('DELETE FROM holidays WHERE id=?')->execute([(int)$_POST['id']]);
        return redirect('/admin/holidays');
    }
}
