<?php
declare(strict_types=1);
namespace App\Controllers\Admin;
use App\Core\DB;

class PaymentConfigController {
    public static function index(): string {
        if (!is_authenticated() || ($_SESSION['role']??'')!=='admin') return redirect('/');
        $pdo = DB::pdo();
        $rows = $pdo->query("SELECT * FROM payment_providers ORDER BY name")->fetchAll();
        return view('admin/payments', ['rows'=>$rows]);
    }
    public static function save(): string {
        if (!is_authenticated() || ($_SESSION['role']??'')!=='admin') return redirect('/');
        if (!csrf_check($_POST['_csrf'] ?? '')) { http_response_code(400); return 'Invalid CSRF'; }
        $pdo = DB::pdo();
        foreach ($_POST['prov'] ?? [] as $name => $cfg) {
            $is_enabled = isset($cfg['enabled']) ? 1 : 0;
            $creds = $cfg['credentials'] ?? '{}';
            $pdo->prepare("INSERT INTO payment_providers (name, credentials, is_enabled) VALUES (?,?,?) ON DUPLICATE KEY UPDATE credentials=VALUES(credentials), is_enabled=VALUES(is_enabled)")
                ->execute([$name, $creds, $is_enabled]);
        }
        return redirect('/admin/payments');
    }
}
