<!doctype html><html lang="pt-BR"><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
<title>Agendar Consulta</title>
</head><body class="hold-transition layout-top-nav">
<div class="wrapper"><div class="content-wrapper p-3"><div class="card card-body">
  <h5>Agende sua consulta</h5>
  <div class="form-group"><label>Profissional</label><select id="doctor" class="form-control"></select></div>
  <div class="form-group"><label>Tipo de consulta</label><select id="consultation" class="form-control"></select><small id="consultInfo" class="form-text text-muted"></small></div>
  <div id="slots" class="row"></div>
</div></div></div>
<script>
async function load(){
  const r = await fetch('/portal/api/doctors'); const docs = await r.json();
  const sel = doctor; sel.innerHTML=''; docs.forEach(d=>{ const o=document.createElement('option'); o.value=d.id; o.text=d.name; sel.appendChild(o); });
  const rc = await fetch('/portal/api/consultations'); const cl = await rc.json();
  const csel = consultation; csel.innerHTML=''; cl.forEach(c=>{ const o=document.createElement('option'); o.value=c.id; o.text = `${c.name} — R$ ${Number(c.price).toFixed(2).replace('.',',')} ${c.is_online? '(online)':''}`; o.dataset.description=c.description||''; csel.appendChild(o); });
  showConsultInfo(); refresh();
}
function showConsultInfo(){ const opt = consultation.options[consultation.selectedIndex]; consultInfo.innerText = opt? (opt.dataset.description||'') : ''; }
async function refresh(){
  const res = await fetch('/portal/api/disponiveis?doctor_id='+encodeURIComponent(doctor.value||'')); const list = await res.json();
  const div = document.getElementById('slots'); div.innerHTML='';
  list.forEach(s=>{
    const btn = document.createElement('button'); btn.className='btn btn-outline-primary m-1'; btn.textContent = `${s.start.substring(0,16)} → ${s.end.substring(11,16)}`;
    btn.onclick = ()=> selectSlot(s.start, s.end);
    div.appendChild(btn);
  });
}
function selectSlot(start,end){
  const form = document.createElement('form'); form.method='post'; form.action='/portal/iniciar';
  const csrf = document.createElement('input'); csrf.type='hidden'; csrf.name='_csrf'; csrf.value='<?= htmlspecialchars(csrf_token()) ?>';
  const s=document.createElement('input'); s.type='hidden'; s.name='start'; s.value=start;
  const e=document.createElement('input'); e.type='hidden'; e.name='end'; e.value=end;
  const d=document.createElement('input'); d.type='hidden'; d.name='doctor_id'; d.value=doctor.value;
  const c=document.createElement('input'); c.type='hidden'; c.name='consultation_type_id'; c.value=consultation.value;
  form.appendChild(csrf); form.appendChild(s); form.appendChild(e); form.appendChild(d); form.appendChild(c); document.body.appendChild(form); form.submit();
}
doctor.addEventListener('change', refresh); consultation.addEventListener('change', showConsultInfo); load();
</script>
</body></html>
