<?php include __DIR__.'/../partials/_hdr.php'; ?>
<section class="content">
  <div class="row">
    <div class="col-lg-6">
      <div class="card card-body">
        <h5>Profissionais — Teleconsulta</h5>
        <form action="/admin/telemed/doctors" method="post">
          <input type="hidden" name="_csrf" value="<?= htmlspecialchars(csrf_token()) ?>">
          <div class="table-responsive"><table class="table table-sm"><thead><tr><th>Nome</th><th>Habilitar</th><th>Plataforma</th></tr></thead><tbody>
          <?php foreach($medicos as $m): ?><tr>
            <td><?= htmlspecialchars($m['name']) ?></td>
            <td><input type="checkbox" name="doc[<?= (int)$m['id'] ?>][enabled]" <?= (int)$m['tele_enabled'] ? 'checked' : '' ?>></td>
            <td><select name="doc[<?= (int)$m['id'] ?>][provider]" class="form-control form-control-sm">
              <option value="zoom" <?= $m['tele_provider']==='zoom'?'selected':'' ?>>Zoom</option>
              <option value="meet" <?= $m['tele_provider']==='meet'?'selected':'' ?>>Google Meet</option>
              <option value="jitsi" <?= $m['tele_provider']==='jitsi'?'selected':'' ?>>Jitsi (fallback)</option>
            </select></td>
          </tr><?php endforeach; ?></tbody></table></div>
          <button class="btn btn-primary">Salvar profissionais</button>
        </form>
      </div>
    </div>
    <div class="col-lg-6">
      <div class="card card-body">
        <h5>Credenciais das Plataformas</h5>
        <form action="/admin/telemed/integrations" method="post">
          <input type="hidden" name="_csrf" value="<?= htmlspecialchars(csrf_token()) ?>">
          <div class="form-group"><label>Zoom (JSON)</label><textarea name="zoom_creds" class="form-control" rows="6"><?= htmlspecialchars($zoom) ?></textarea></div>
          <div class="form-group"><label>Google Meet (JSON)</label><textarea name="meet_creds" class="form-control" rows="6"><?= htmlspecialchars($meet) ?></textarea></div>
          <button class="btn btn-success">Salvar credenciais</button>
        </form>
        <div class="alert alert-info mt-3"><b>Dica:</b> sem credenciais, usamos <u>Jitsi</u> automaticamente.</div>
      </div>
    </div>
  </div>
</section>
<?php include __DIR__.'/../partials/_ftr.php'; ?>
