<?php
declare(strict_types=1);
namespace App\Telemed;
use App\Core\DB;
class TeleService {
    public static function createForAppointment(int $appointmentId): ?array {
        $pdo = DB::pdo();
        $stmt = $pdo->prepare("SELECT a.*, u.name AS doctor_name, u.tele_enabled, u.tele_provider, p.name AS patient_name, ct.is_online
                               FROM appointments a
                               JOIN users u ON u.id = a.doctor_id
                               JOIN patients p ON p.id = a.patient_id
                               LEFT JOIN consultation_types ct ON ct.id = a.consultation_type_id
                               WHERE a.id = ?");
        $stmt->execute([$appointmentId]); $a = $stmt->fetch();
        if (!$a || (int)$a['is_online'] !== 1 || (int)$a['tele_enabled'] !== 1) return null;
        $provider = $a['tele_provider'] ?: 'jitsi';
        if ($provider === 'zoom') { $q=$pdo->prepare("SELECT credentials FROM integrations WHERE name='zoom' LIMIT 1"); $q->execute([]); $creds=json_decode($q->fetchColumn() ?: '{}', true); $klass = \App\Telemed\ZoomProvider::class; }
        elseif ($provider === 'meet') { $q=$pdo->prepare("SELECT credentials FROM integrations WHERE name='google_meet' LIMIT 1"); $q->execute([]); $creds=json_decode($q->fetchColumn() ?: '{}', true); $klass = \App\Telemed\GoogleMeetProvider::class; }
        else { $klass = \App\Telemed\JitsiProvider::class; $creds=['base'=>getenv('TELEMEET_BASE') ?: 'https://meet.jit.si']; }
        $adapter = new $klass();
        $out = $adapter->createMeeting($creds, ['topic'=>'Consulta - '.$a['patient_name'].' / '.$a['doctor_name'], 'start_time'=>$a['start_time']]);
        if ($out) { @file_put_contents(__DIR__.'/../storage/tele_'.$appointmentId.'.json', json_encode($out)); }
        return $out;
    }
}
