<?php
declare(strict_types=1);
namespace App\Controllers;
use App\Core\DB;

class ScheduleController {
    public static function index(): string {
        if (!is_authenticated()) return redirect('/');
        $pdo = DB::pdo();
        $rows = $pdo->prepare("SELECT * FROM schedule_blocks WHERE user_id=? ORDER BY start_time DESC"); $rows->execute([$_SESSION['user_id']]);
        return view('schedule/blocks', ['rows'=>$rows->fetchAll()]);
    }
    public static function add(): string {
        if (!is_authenticated()) return redirect('/');
        if (!csrf_check($_POST['_csrf'] ?? '')) { http_response_code(400); return 'Invalid CSRF'; }
        $pdo = DB::pdo();
        $pdo->prepare("INSERT INTO schedule_blocks (user_id, start_time, end_time, reason) VALUES (?,?,?,?)")->execute([$_SESSION['user_id'], $_POST['start'], $_POST['end'], $_POST['reason'] ?? null]);
        return redirect('/schedule/blocks');
    }
    public static function remove(): string {
        if (!is_authenticated()) return redirect('/');
        if (!csrf_check($_POST['_csrf'] ?? '')) { http_response_code(400); return 'Invalid CSRF'; }
        $pdo = DB::pdo();
        $pdo->prepare("DELETE FROM schedule_blocks WHERE id=? AND user_id=?")->execute([(int)$_POST['id'], $_SESSION['user_id']]);
        return redirect('/schedule/blocks');
    }
    public static function calendar(): string {
        if (!is_authenticated()) return redirect('/');
        return view('appointments/index');
    }
}
