<?php
declare(strict_types=1);
namespace App\Controllers;
use App\Core\DB;

class PatientPortalController {
    public static function register(): string { return view('portal/register'); }
    public static function doRegister(): string {
        if (!csrf_check($_POST['_csrf'] ?? '')) { http_response_code(400); return 'Invalid CSRF'; }
        $pdo = DB::pdo();
        $pdo->prepare("INSERT INTO patients (name, email, phone) VALUES (?,?,?)")->execute([$_POST['name'], $_POST['email'], $_POST['phone'] ?? null]);
        return redirect('/portal/login');
    }
    public static function login(): string { return view('portal/login'); }
    public static function doLogin(): string {
        $pdo = DB::pdo();
        $q=$pdo->prepare("SELECT * FROM patients WHERE email=? LIMIT 1"); $q->execute([$_POST['email'] ?? '']); $p=$q->fetch();
        if (!$p) return view('portal/login',['error'=>'Paciente não encontrado']);
        $_SESSION['portal_patient_id'] = (int)$p['id']; $_SESSION['portal_patient_name'] = $p['name'];
        return redirect('/portal/agenda');
    }
    public static function agenda(): string { if (empty($_SESSION['portal_patient_id'])) return redirect('/portal/login'); return view('portal/agenda'); }
    public static function apiConsultations(): string {
        header('Content-Type: application/json; charset=utf-8'); $pdo=DB::pdo();
        $rows = $pdo->query("SELECT id,name,description,price,is_online FROM consultation_types WHERE is_active=1 ORDER BY name")->fetchAll();
        return json_encode($rows);
    }
    public static function apiDoctors(): string {
        header('Content-Type: application/json; charset=utf-8'); $pdo=DB::pdo();
        $rows = $pdo->query("SELECT id,name FROM users WHERE role='medico' AND is_active=1 ORDER BY name")->fetchAll();
        return json_encode($rows);
    }
    public static function apiDisponiveis(): string {
        header('Content-Type: application/json; charset=utf-8');
        $pdo = DB::pdo(); $days = 21;
        $doctorId = (int)($_GET['doctor_id'] ?? 0);
        $out = [];
        for ($d=0; $d<$days; $d++) {
            $date = date('Y-m-d', strtotime("+$d day"));
            $isHoliday = $pdo->prepare("SELECT 1 FROM holidays WHERE date=? LIMIT 1"); $isHoliday->execute([$date]); if ($isHoliday->fetch()) continue;
            $weekday = (int)date('N', strtotime($date));
            $wh = $pdo->prepare("SELECT start_time,end_time FROM working_hours WHERE user_id=? AND weekday=?");
            $wh->execute([$doctorId, $weekday]); $ranges = $wh->fetchAll(); if (!$ranges) continue;
            foreach ($ranges as $r) {
                $startH = (int)substr($r['start_time'],0,2); $endH = (int)substr($r['end_time'],0,2);
                for ($h=$startH; $h<$endH; $h++) {
                    foreach ([0,30] as $m) {
                        $start = sprintf('%s %02d:%02d:00',$date,$h,$m);
                        $end = date('Y-m-d H:i:s', strtotime($start)+30*60);
                        $has = $pdo->prepare("SELECT 1 FROM appointments WHERE doctor_id=? AND start_time < ? AND end_time > ? LIMIT 1"); $has->execute([$doctorId,$end,$start]);
                        if ($has->fetch()) continue;
                        $blk = $pdo->prepare("SELECT 1 FROM schedule_blocks WHERE user_id=? AND start_time < ? AND end_time > ? LIMIT 1"); $blk->execute([$doctorId,$end,$start]);
                        if ($blk->fetch()) continue;
                        $out[] = ['start'=>$start,'end'=>$end];
                    }
                }
            }
        }
        return json_encode($out);
    }
    public static function iniciarAgendamento(): string {
        if (empty($_SESSION['portal_patient_id'])) return redirect('/portal/login');
        if (!csrf_check($_POST['_csrf'] ?? '')) { http_response_code(400); return 'Invalid CSRF'; }
        $pdo = DB::pdo();
        $start = $_POST['start']; $end = $_POST['end']; $doctorId = (int)($_POST['doctor_id'] ?? 0); $consultId = (int)($_POST['consultation_type_id'] ?? 0);
        $pdo->prepare("INSERT INTO invoices (patient_id, description, amount, due_date, status) VALUES (?,?,?,?, 'aberta')")->execute([$_SESSION['portal_patient_id'], 'Consulta', 0, substr($start,0,10)]);
        $invoiceId = (int)$pdo->lastInsertId();
        return redirect('/portal/pagar?invoice_id='.$invoiceId.'&start='.urlencode($start).'&end='.urlencode($end).'&doctor_id='.$doctorId.'&consultation_type_id='.$consultId);
    }
}
