<?php
declare(strict_types=1);
namespace App\Controllers;
use App\Core\DB;

class PatientAppointmentsController {
    public static function list(): string {
        if (empty($_SESSION['portal_patient_id'])) return redirect('/portal/login');
        $pdo = DB::pdo();
        $rows = $pdo->prepare("SELECT a.id, a.start_time, a.end_time, u.name AS doctor, ct.name AS consult, ct.is_online
                               FROM appointments a
                               JOIN users u ON u.id=a.doctor_id
                               LEFT JOIN consultation_types ct ON ct.id=a.consultation_type_id
                               WHERE a.patient_id=? AND a.start_time >= DATE_SUB(NOW(), INTERVAL 30 DAY)
                               ORDER BY a.start_time ASC");
        $rows->execute([$_SESSION['portal_patient_id']]);
        return view('portal/my_appointments', ['rows'=>$rows->fetchAll()]);
    }
    public static function detail(): string {
        if (empty($_SESSION['portal_patient_id'])) return redirect('/portal/login');
        $id = (int)($_GET['id'] ?? 0);
        $pdo = DB::pdo();
        $row = $pdo->prepare("SELECT a.*, u.name AS doctor, ct.name AS consult, ct.is_online FROM appointments a
                               JOIN users u ON u.id=a.doctor_id
                               LEFT JOIN consultation_types ct ON ct.id=a.consultation_type_id
                               WHERE a.id=? AND a.patient_id=?");
        $row->execute([$id, $_SESSION['portal_patient_id']]);
        $a = $row->fetch();
        if (!$a) { http_response_code(404); return 'Consulta não encontrada'; }
        $urls = null;
        if ((int)$a['is_online'] === 1) { $file = __DIR__.'/../../storage/tele_'.$a['id'].'.json'; if (is_file($file)) { $urls = json_decode(file_get_contents($file), true); } }
        return view('portal/appointment_detail', ['a'=>$a, 'urls'=>$urls]);
    }
}
