<?php
declare(strict_types=1);
namespace App\Controllers\Admin;
use App\Core\DB;

class ConsultationAdminController {
    public static function index(): string {
        if (!is_authenticated() || ($_SESSION['role']??'')!=='admin') return redirect('/');
        $pdo = DB::pdo();
        $rows = $pdo->query("SELECT * FROM consultation_types ORDER BY is_active DESC, name")->fetchAll();
        return view('admin/consultations', ['rows'=>$rows]);
    }
    public static function save(): string {
        if (!is_authenticated() || ($_SESSION['role']??'')!=='admin') return redirect('/');
        if (!csrf_check($_POST['_csrf'] ?? '')) { http_response_code(400); return 'Invalid CSRF'; }
        $pdo = DB::pdo();
        $id = (int)($_POST['id'] ?? 0);
        $name = trim($_POST['name'] ?? '');
        $desc = trim($_POST['description'] ?? '');
        $price = (float)($_POST['price'] ?? 0);
        $active = isset($_POST['is_active']) ? 1 : 0;
        $online = isset($_POST['is_online']) ? 1 : 0;
        if ($id > 0) {
            $stmt = $pdo->prepare("UPDATE consultation_types SET name=?, description=?, price=?, is_active=?, is_online=?, updated_at=NOW() WHERE id=?");
            $stmt->execute([$name,$desc,$price,$active,$online,$id]);
        } else {
            $stmt = $pdo->prepare("INSERT INTO consultation_types (name, description, price, is_active, is_online) VALUES (?,?,?,?,?)");
            $stmt->execute([$name,$desc,$price,$active,$online]);
        }
        return redirect('/admin/consultations');
    }
    public static function delete(): string {
        if (!is_authenticated() || ($_SESSION['role']??'')!=='admin') return redirect('/');
        if (!csrf_check($_POST['_csrf'] ?? '')) { http_response_code(400); return 'Invalid CSRF'; }
        $pdo = DB::pdo();
        $id = (int)($_POST['id'] ?? 0);
        $pdo->prepare("DELETE FROM consultation_types WHERE id=?")->execute([$id]);
        return redirect('/admin/consultations');
    }
}
