# Sistema de Consultório de Psiquiatria — PHP 8.1 + MySQL (Pacote Completo)

## O que contém
- Portal do paciente com **agendamento por conta própria** (somente particular) e **pagamento antecipado** (adapters: PagSeguro, Mercado Pago, Pagar.me, Cielo, Rede, Pix — **simulados** por padrão).
- Agenda por profissional com **jornadas**, **feriados** e **bloqueios**; mostra apenas **horários disponíveis**.
- Tipos de consulta (nome, **descrição**, **preço**, **online/presencial**).
- **Teleconsulta** por profissional (Zoom/Google Meet via credenciais, com fallback **Jitsi**). Link liberado ao paciente **no dia** da consulta; médico tem botão para **entrar na sala**.
- Painel Admin: hub de **Configurações**, **Meios de Pagamento**, **Consultas (precificação/descrição)**, **Jornadas**, **Feriados**, **Bloqueios**, **2FA TOTP**.
- Segurança básica: CSRF, prepared statements, separação de perfis, 2FA opcional/obrigatório para perfis sensíveis quando ativado.

## Requisitos
- PHP 8.1+ com PDO MySQL
- MySQL 8+ (ou 5.7+ com JSON)
- Servidor web apontando para `public/`

## Instalação
1. Crie o banco (ex.: `psiquiatria`) e configure variáveis de ambiente:
   - `DB_HOST`, `DB_NAME`, `DB_USER`, `DB_PASS`
   - opcional: `APP_URL` (ex.: `https://sua-clinica.com`)
2. Rode as migrations em `database/migrations` (em ordem; pode executar todas de uma vez).
3. Acesse `/` (login Admin): e-mail `admin@local`, senha `admin123` (troque em produção!).
4. Em **Admin → Consultas**, cadastre/ajuste tipos de consulta e marque **online** quando aplicável.
5. Em **Admin → Working Hours** e **Holidays**, defina jornadas e feriados.
6. Em **Admin → Meios de Pagamento**, habilite os PSPs (ficarão simulados até você implementar as chamadas reais no adapter).
7. Em **Admin → Teleconsulta**, habilite por profissional e informe credenciais (Zoom/Meet). Sem credenciais, o sistema usa **Jitsi** automaticamente.

## Observações
- Os adapters de pagamento e de vídeo estão prontos para receber as **credenciais** e realizar as chamadas reais (cURL). Atualmente redirecionam ao **checkout simulado**.
- Para **2FA**, acesse **/security/totp** (gera secret + validação TOTP).
- O **Portal do Paciente** mostra o link da sala **somente no dia** da consulta.
