<?php
declare(strict_types=1);
require __DIR__ . '/../app/Core/DB.php';
require __DIR__ . '/../app/Core/Router.php';
require __DIR__ . '/../app/helpers.php';

require __DIR__ . '/../app/Controllers/AuthController.php';
require __DIR__ . '/../app/Controllers/ScheduleController.php';
require __DIR__ . '/../app/Controllers/PaymentController.php';
require __DIR__ . '/../app/Controllers/PatientPortalController.php';
require __DIR__ . '/../app/Controllers/SecurityController.php';
require __DIR__ . '/../app/Controllers/AppointmentDetailApi.php';
require __DIR__ . '/../app/Controllers/PatientAppointmentsController.php';

require __DIR__ . '/../app/Controllers/Admin/PaymentConfigController.php';
require __DIR__ . '/../app/Controllers/Admin/ScheduleAdminController.php';
require __DIR__ . '/../app/Controllers/Admin/ConsultationAdminController.php';
require __DIR__ . '/../app/Controllers/Admin/SettingsController.php';
require __DIR__ . '/../app/Controllers/Admin/TelemedController.php';

require __DIR__ . '/../app/Payments/ProviderInterface.php';
require __DIR__ . '/../app/Payments/PagSeguroProvider.php';
require __DIR__ . '/../app/Payments/MercadoPagoProvider.php';
require __DIR__ . '/../app/Payments/PagarmeProvider.php';
require __DIR__ . '/../app/Payments/CieloProvider.php';
require __DIR__ . '/../app/Payments/RedeProvider.php';
require __DIR__ . '/../app/Payments/PixProvider.php';

require __DIR__ . '/../app/Telemed/TeleProviderInterface.php';
require __DIR__ . '/../app/Telemed/ZoomProvider.php';
require __DIR__ . '/../app/Telemed/GoogleMeetProvider.php';
require __DIR__ . '/../app/Telemed/JitsiProvider.php';
require __DIR__ . '/../app/Telemed/TeleService.php';

use App\Core\Router;
use App\Controllers\AuthController;
use App\Controllers\ScheduleController;
use App\Controllers\PaymentController;
use App\Controllers\PatientPortalController;
use App\Controllers\SecurityController;
use App\Controllers\AppointmentDetailApi;
use App\Controllers\PatientAppointmentsController;
use App\Controllers\Admin\PaymentConfigController;
use App\Controllers\Admin\ScheduleAdminController;
use App\Controllers\Admin\ConsultationAdminController;
use App\Controllers\Admin\SettingsController;
use App\Controllers\Admin\TelemedController;

$router = new Router();

// Auth
$router->get('/', fn()=> view('auth/login'));
$router->post('/login', [AuthController::class, 'login']);
$router->get('/logout', [AuthController::class, 'logout']);

// Admin areas
$router->get('/admin/payments', [PaymentConfigController::class, 'index']);
$router->post('/admin/payments', [PaymentConfigController::class, 'save']);

$router->get('/admin/working-hours', [ScheduleAdminController::class, 'workingHours']);
$router->post('/admin/working-hours', [ScheduleAdminController::class, 'saveWorkingHours']);
$router->get('/admin/holidays', [ScheduleAdminController::class, 'holidays']);
$router->post('/admin/holidays/add', [ScheduleAdminController::class, 'addHoliday']);
$router->post('/admin/holidays/del', [ScheduleAdminController::class, 'delHoliday']);

$router->get('/admin/consultations', [ConsultationAdminController::class, 'index']);
$router->post('/admin/consultations', [ConsultationAdminController::class, 'save']);
$router->post('/admin/consultations/delete', [ConsultationAdminController::class, 'delete']);

$router->get('/admin/settings', [SettingsController::class, 'index']);
$router->get('/admin/telemed', [TelemedController::class, 'index']);
$router->post('/admin/telemed/doctors', [TelemedController::class, 'saveDoctors']);
$router->post('/admin/telemed/integrations', [TelemedController::class, 'saveIntegrations']);

// Schedule blocks (pro)
$router->get('/schedule/blocks', [ScheduleController::class, 'index']);
$router->post('/schedule/blocks/add', [ScheduleController::class, 'add']);
$router->post('/schedule/blocks/remove', [ScheduleController::class, 'remove']);

// Security
$router->get('/security/totp', [SecurityController::class, 'totpSetup']);
$router->post('/security/totp/enable', [SecurityController::class, 'totpEnable']);

// API
$router->get('/portal/api/disponiveis', [PatientPortalController::class, 'apiDisponiveis']);
$router->get('/portal/api/doctors', [PatientPortalController::class, 'apiDoctors']);
$router->get('/portal/api/consultations', [PatientPortalController::class, 'apiConsultations']);
$router->get('/api/appointment/detail', [AppointmentDetailApi::class, 'get']);

// Patient Portal
$router->get('/portal/register', [PatientPortalController::class, 'register']);
$router->post('/portal/register', [PatientPortalController::class, 'doRegister']);
$router->get('/portal/login', [PatientPortalController::class, 'login']);
$router->post('/portal/login', [PatientPortalController::class, 'doLogin']);
$router->get('/portal/agenda', [PatientPortalController::class, 'agenda']);
$router->post('/portal/iniciar', [PatientPortalController::class, 'iniciarAgendamento']);
$router->get('/portal/pagar', [PaymentController::class, 'selecionar']);
$router->post('/portal/pagar', [PaymentController::class, 'criarPagamento']);
$router->get('/portal/confirmar', [PaymentController::class, 'confirmar']);
$router->get('/portal/checkout_simulado', [PaymentController::class, 'checkoutSimulado']);

$router->get('/portal/consultas', [PatientAppointmentsController::class, 'list']);
$router->get('/portal/consulta', [PatientAppointmentsController::class, 'detail']);

// Appointments UI
$router->get('/appointments', [ScheduleController::class, 'calendar']);

// Dispatch
$router->dispatch();
