<?php
use App\Core\DB;

if (session_status() !== PHP_SESSION_ACTIVE) { session_start(); }

function env(string $k, $default=null){ $v = $_ENV[$k] ?? getenv($k); return $v !== false && $v !== null ? $v : $default; }

function view(string $name, array $data=[]){
    extract($data);
    ob_start();
    $file = __DIR__ . '/Views/' . str_replace('..','',$name) . '.php';
    if (!is_file($file)) { return "View not found: $name"; }
    include $file;
    return ob_get_clean();
}

function redirect(string $url){ header('Location: '.$url); exit; }

function is_authenticated(): bool { return !empty($_SESSION['user_id']); }

function csrf_token(): string {
    if (empty($_SESSION['_csrf'])) $_SESSION['_csrf'] = bin2hex(random_bytes(16));
    return $_SESSION['_csrf'];
}
function csrf_check(string $token): bool { return hash_equals($_SESSION['_csrf'] ?? '', $token); }

function sanitize_str($s){ return trim((string)$s); }

# --- TOTP (RFC 6238) using HMAC-SHA1 ---
function hotp(string $secretBytes, int $counter): string {
    $binCounter = pack('J', $counter);
    $hash = hash_hmac('sha1', $binCounter, $secretBytes, true);
    $offset = ord(substr($hash, -1)) & 0x0F;
    $trunc = (ord($hash[$offset]) & 0x7F) << 24
           | (ord($hash[$offset+1]) & 0xFF) << 16
           | (ord($hash[$offset+2]) & 0xFF) << 8
           | (ord($hash[$offset+3]) & 0xFF);
    $code = $trunc % 1000000;
    return str_pad((string)$code, 6, '0', STR_PAD_LEFT);
}
function totp_verify(string $secret, string $code, int $window=1, int $period=30): bool {
    $code = preg_replace('/\D/', '', $code);
    if (strlen($code) !== 6) return false;
    // accept hex or base32-like secrets; here we assume hex
    if (!preg_match('/^[A-Fa-f0-9]+$/', $secret)) { $secret = bin2hex($secret); }
    $secretBytes = hex2bin($secret);
    $time = time();
    $ctr = intdiv($time, $period);
    for ($i=-$window; $i<=$window; $i++) {
        if (hotp($secretBytes, $ctr+$i) === $code) return true;
    }
    return false;
}
