<?php include __DIR__.'/../partials/_hdr.php'; ?>
<section class="content"><div class="card card-body">
  <h5>Bloqueios da Agenda</h5>
  <form action="/schedule/blocks/add" method="post" class="mb-3"><input type="hidden" name="_csrf" value="<?= htmlspecialchars(csrf_token()) ?>">
    <div class="form-row">
      <div class="col"><input type="datetime-local" name="start" class="form-control" required></div>
      <div class="col"><input type="datetime-local" name="end" class="form-control" required></div>
      <div class="col"><input name="reason" class="form-control" placeholder="Motivo"></div>
      <div class="col"><button class="btn btn-primary">Adicionar</button></div>
    </div>
  </form>
  <table class="table table-sm"><thead><tr><th>Início</th><th>Fim</th><th>Motivo</th><th></th></tr></thead><tbody>
  <?php foreach($rows as $r): ?><tr>
    <td><?= htmlspecialchars($r['start_time']) ?></td><td><?= htmlspecialchars($r['end_time']) ?></td><td><?= htmlspecialchars($r['reason'] ?? '') ?></td>
    <td><form action="/schedule/blocks/remove" method="post"><input type="hidden" name="_csrf" value="<?= htmlspecialchars(csrf_token()) ?>"><input type="hidden" name="id" value="<?= (int)$r['id'] ?>"><button class="btn btn-sm btn-danger">Remover</button></form></td>
  </tr><?php endforeach; ?></tbody></table>
</div></section>
<?php include __DIR__.'/../partials/_ftr.php'; ?>
