<?php
declare(strict_types=1);
namespace App\Core;

class Router {
    private array $routes = ['GET'=>[], 'POST'=>[]];
    public function get(string $path, $handler){ $this->routes['GET'][$path] = $handler; }
    public function post(string $path, $handler){ $this->routes['POST'][$path] = $handler; }
    public function dispatch(){
        $method = $_SERVER['REQUEST_METHOD'];
        $uri = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
        $handler = $this->routes[$method][$uri] ?? null;
        if (!$handler) { http_response_code(404); echo "404 Not Found"; return; }
        if (is_array($handler)) { [ $klass, $fn ] = $handler; echo $klass::$fn(); }
        elseif (is_callable($handler)) { echo $handler(); }
        else { http_response_code(500); echo "Bad route"; }
    }
}
