<?php
declare(strict_types=1);
namespace App\Controllers;
use App\Core\DB;

class SecurityController {
    public static function totpSetup(): string {
        if (!is_authenticated()) return redirect('/');
        $pdo = DB::pdo();
        $uid = $_SESSION['user_id'];
        $u = $pdo->prepare('SELECT email, totp_secret, totp_enabled FROM users WHERE id = ?');
        $u->execute([$uid]); $user = $u->fetch();
        $secret = $user['totp_secret'] ?? null;
        if (!$secret) {
            $raw = random_bytes(20);
            $secret = bin2hex($raw);
            $pdo->prepare('UPDATE users SET totp_secret=? WHERE id=?')->execute([$secret, $uid]);
        }
        $issuer = urlencode('ClinicaPsiquiatria');
        $label = urlencode($_SESSION['user_name'] . ' (' . ($_SESSION['role']??'') . ')');
        $otpauth = 'otpauth://totp/'.$issuer.':'.$label.'?secret='.$secret.'&issuer='.$issuer.'&digits=6&period=30';
        return view('security/totp_setup', ['secret'=>$secret, 'otpauth'=>$otpauth, 'enabled'=>(int)$user['totp_enabled']]);
    }
    public static function totpEnable(): string {
        if (!is_authenticated()) return redirect('/');
        if (!csrf_check($_POST['_csrf'] ?? '')) { http_response_code(400); return 'Invalid CSRF'; }
        $code = $_POST['code'] ?? '';
        $pdo = DB::pdo(); $uid = $_SESSION['user_id'];
        $u = $pdo->prepare('SELECT totp_secret FROM users WHERE id = ?'); $u->execute([$uid]); $user = $u->fetch();
        if (!$user) return 'User not found';
        if (!function_exists('totp_verify')) { return 'TOTP function missing'; }
        if (totp_verify(strtoupper($user['totp_secret']), $code)) {
            $pdo->prepare('UPDATE users SET totp_enabled=1 WHERE id=?')->execute([$uid]);
            return redirect('/security/totp');
        }
        return view('security/totp_setup', ['secret'=>$user['totp_secret'], 'otpauth'=>'', 'enabled'=>0, 'error'=>'Código inválido']);
    }
}
