<?php
declare(strict_types=1);
namespace App\Controllers;
use App\Core\DB;

class PaymentController {
    public static function selecionar(): string {
        if (empty($_SESSION['portal_patient_id'])) return redirect('/portal/login');
        $invoiceId = (int)($_GET['invoice_id'] ?? 0);
        $start = $_GET['start'] ?? ''; $end = $_GET['end'] ?? ''; $consultId = (int)($_GET['consultation_type_id'] ?? 0);
        $pdo = DB::pdo();
        $prov = $pdo->query("SELECT name, is_enabled FROM payment_providers ORDER BY name")->fetchAll();
        return view('portal/pagar', ['providers'=>$prov, 'invoiceId'=>$invoiceId, 'start'=>$start, 'end'=>$end, 'consultId'=>$consultId]);
    }
    public static function criarPagamento(): string {
        if (empty($_SESSION['portal_patient_id'])) return redirect('/portal/login');
        $pdo = DB::pdo();
        $invoiceId = (int)($_POST['invoice_id'] ?? 0);
        $provider = $_POST['provider'] ?? 'Pix';
        $start = $_POST['start'] ?? ''; $end = $_POST['end'] ?? '';
        $doctorId = (int)($_GET['doctor_id'] ?? ($_POST['doctor_id'] ?? 0));
        $consultId = (int)($_POST['consultation_type_id'] ?? 0);
        // price/description
        $name = 'Consulta particular'; $amount = 350.00;
        if ($consultId > 0) { $q=$pdo->prepare("SELECT name, price FROM consultation_types WHERE id=?"); $q->execute([$consultId]); if ($r=$q->fetch()){ $name=$r['name']; $amount=(float)$r['price']; } }
        $pdo->prepare("UPDATE invoices SET amount=?, description=? WHERE id=?")->execute([$amount, $name, $invoiceId]);

        // provider adapter
        $cfg = $pdo->prepare("SELECT * FROM payment_providers WHERE name=? AND is_enabled=1"); $cfg->execute([$provider]); $row = $cfg->fetch();
        $credentials = $row ? json_decode($row['credentials'] ?: '{}', true) : [];
        $map = [
            'PagSeguro' => \App\Payments\PagSeguroProvider::class,
            'MercadoPago' => \App\Payments\MercadoPagoProvider::class,
            'Pagar.me' => \App\Payments\PagarmeProvider::class,
            'Pagarme' => \App\Payments\PagarmeProvider::class,
            'Cielo' => \App\Payments\CieloProvider::class,
            'Rede' => \App\Payments\RedeProvider::class,
            'Pix' => \App\Payments\PixProvider::class,
        ];
        $klass = $map[$provider] ?? null; $redirect = '/portal/checkout_simulado'; $pref = 'SIM-' . uniqid();
        if ($klass) {
            $adapter = new $klass();
            $params = [
                'amount'=>$amount,'currency'=>'BRL','description'=>$name,
                'return_url'=>(env('APP_URL','http://localhost').'/portal/confirmar'),
                'webhook_url'=>(env('APP_URL','http://localhost').'/webhook/payments'),
                'payer'=>['id'=>$_SESSION['portal_patient_id'] ?? null, 'doctor_id'=>$doctorId]
            ];
            try { $out = $adapter->createCheckout($credentials, $params); $redirect = $out['redirect_url'] ?? $redirect; $pref = $out['provider_ref'] ?? $pref; } catch (\Throwable $e) {}
        }
        $stmt = $pdo->prepare("INSERT INTO payments_external (invoice_id, provider, status, provider_ref, payload) VALUES (?,?, 'pending', ?, JSON_OBJECT('start', ?, 'end', ?, 'doctor_id', ?, 'consultation_type_id', ?, 'amount', ?, 'name', ?))");
        $stmt->execute([$invoiceId, $provider, $pref, $start, $end, $doctorId, $consultId, $amount, $name]);
        $pxid = (int)$pdo->lastInsertId();
        if ($redirect === '/portal/checkout_simulado') {
            return view('portal/checkout_simulado', ['pxid'=>$pxid, 'invoiceId'=>$invoiceId, 'provider'=>$provider, 'start'=>$start, 'end'=>$end]);
        }
        header('Location: '.$redirect); exit;
    }
    public static function checkoutSimulado(): string {
        if (empty($_SESSION['portal_patient_id'])) return redirect('/portal/login');
        return view('portal/checkout_simulado', ['pxid'=>(int)($_GET['pxid'] ?? 0), 'invoiceId'=>(int)($_GET['invoiceId'] ?? 0), 'provider'=>($_GET['provider'] ?? 'Pix'), 'start'=>($_GET['start'] ?? ''), 'end'=>($_GET['end'] ?? '')]);
    }
    public static function confirmar(): string {
        if (empty($_SESSION['portal_patient_id'])) return redirect('/portal/login');
        $pdo = DB::pdo();
        $inv = $pdo->prepare("SELECT id FROM invoices WHERE patient_id=? ORDER BY id DESC LIMIT 1"); $inv->execute([$_SESSION['portal_patient_id']]); $invoice = $inv->fetch();
        $px = $pdo->prepare("SELECT * FROM payments_external WHERE invoice_id=? ORDER BY id DESC LIMIT 1"); $px->execute([$invoice['id'] ?? 0]); $px = $px->fetch();
        if (!$px) return 'Pagamento não localizado';
        $payload = json_decode($px['payload'] ?? '{}', true);
        $start = $payload['start'] ?? null; $end = $payload['end'] ?? null; $consultId = $payload['consultation_type_id'] ?? null; $name = $payload['name'] ?? 'Consulta particular';
        if ($start && $end) {
            $stmt = $pdo->prepare("INSERT INTO appointments (patient_id, start_time, end_time, type, status, notes, doctor_id, consultation_type_id) VALUES (?,?,?,?,?,?,?,?)");
            $stmt->execute([$_SESSION['portal_patient_id'], $start, $end, 'consulta', 'confirmado', 'Agendado via portal — ' . $name, $payload['doctor_id'] ?? null, $consultId]);
            $apptId = (int)$pdo->lastInsertId();
            $isOnline = (int)$pdo->query("SELECT is_online FROM consultation_types WHERE id=".$consultId)->fetchColumn();
            if ($isOnline === 1) { require_once __DIR__ . '/../Telemed/TeleService.php'; \App\Telemed\TeleService::createForAppointment($apptId); }
        }
        return redirect('/portal/consultas?ok=1');
    }
}
