<?php
declare(strict_types=1);
namespace App\Controllers;
use App\Core\DB;

class AuthController {
    public static function login(): string {
        $email = $_POST['email'] ?? '';
        $pass = $_POST['password'] ?? '';
        $pdo = DB::pdo();
        $q = $pdo->prepare("SELECT * FROM users WHERE email=? AND is_active=1 LIMIT 1");
        $q->execute([$email]); $user = $q->fetch();
        if (!$user || !password_verify($pass, $user['password_hash'])) {
            return view('auth/login', ['error'=>'Credenciais inválidas']);
        }
        // Enforce TOTP for sensitive roles
        if (in_array($user['role'], ['admin','medico','financeiro'])) {
            if ((int)$user['totp_enabled'] === 1) {
                $totp = $_POST['totp'] ?? '';
                if (!$totp || !function_exists('totp_verify') || !totp_verify(strtoupper($user['totp_secret']), $totp)) {
                    return view('auth/login', ['error'=>'Informe um TOTP válido (2FA)']);
                }
            }
        }
        $_SESSION['user_id'] = (int)$user['id'];
        $_SESSION['user_name'] = $user['name'];
        $_SESSION['role'] = $user['role'];
        return redirect('/admin/settings');
    }
    public static function logout(): string { session_destroy(); return redirect('/'); }
}
