<?php
declare(strict_types=1);
namespace App\Controllers\Admin;
use App\Core\DB;

class TelemedController {
    public static function index(): string {
        if (!is_authenticated() || ($_SESSION['role']??'')!=='admin') return redirect('/');
        $pdo = DB::pdo();
        $medicos = $pdo->query("SELECT id, name, tele_enabled, tele_provider FROM users WHERE role='medico' AND is_active=1 ORDER BY name")->fetchAll();
        $zoom = $pdo->prepare("SELECT credentials FROM integrations WHERE name='zoom' LIMIT 1"); $zoom->execute([]); $zoom = $zoom->fetchColumn();
        $meet = $pdo->prepare("SELECT credentials FROM integrations WHERE name='google_meet' LIMIT 1"); $meet->execute([]); $meet = $meet->fetchColumn();
        return view('admin/telemed', ['medicos'=>$medicos, 'zoom'=>$zoom ?: '{}', 'meet'=>$meet ?: '{}']);
    }
    public static function saveDoctors(): string {
        if (!is_authenticated() || ($_SESSION['role']??'')!=='admin') return redirect('/');
        if (!csrf_check($_POST['_csrf'] ?? '')) { http_response_code(400); return 'Invalid CSRF'; }
        $pdo = DB::pdo();
        foreach ($_POST['doc'] ?? [] as $id => $row) {
            $id = (int)$id;
            $enabled = isset($row['enabled']) ? 1 : 0;
            $prov = in_array($row['provider'] ?? 'jitsi', ['zoom','meet','jitsi']) ? $row['provider'] : 'jitsi';
            $pdo->prepare("UPDATE users SET tele_enabled=?, tele_provider=? WHERE id=?")->execute([$enabled,$prov,$id]);
        }
        return redirect('/admin/telemed');
    }
    public static function saveIntegrations(): string {
        if (!is_authenticated() || ($_SESSION['role']??'')!=='admin') return redirect('/');
        if (!csrf_check($_POST['_csrf'] ?? '')) { http_response_code(400); return 'Invalid CSRF'; }
        $pdo = DB::pdo();
        $pairs = [['zoom', $_POST['zoom_creds'] ?? '{}'], ['google_meet', $_POST['meet_creds'] ?? '{}']];
        foreach ($pairs as [$name, $json]) { $pdo->prepare("INSERT INTO integrations (name, credentials) VALUES (?,?) ON DUPLICATE KEY UPDATE credentials=VALUES(credentials), updated_at=NOW()")->execute([$name,$json]); }
        return redirect('/admin/telemed');
    }
}
